//Dustin Soodak
#include "Arduino.h"

#ifndef NAVIGATION_H
#define NAVIGATION_H


#include "MMA8451Q.h"
#include "L3GD20.h"

//Un-comment one:
#define INT_VER // 1/3 ms run time for calculation section
//#define FLOAT_VER // 1 ms run time but slightly more accurate. mainly here to show what INT_VER is doing



// ***************************************************
// Navigation
// ***************************************************

extern char AccelFifoOverflow;
extern char GyroFifoOverflow;

extern void NavigationBegin(void);
extern char NavigationOn;
extern void SimpleGyroNavigation(void);
extern void SimpleNavigation(void);
extern void NavigationXY(int GyroSensitivity, int AccelSensitivity);//50,500 are good input values
//would put in interrupt, but I2C library can't be used in an interrupt and also takes more than 
//1ms so would interfere with millis() function.

extern void ZeroNavigationSensors(void);//NavigationBegin() does this
extern void ZeroNavigation(void);//NavigationBegin() does this
extern void PauseNavigation(void);//call after NavigationBegin() if NavigationHandlerSimple() not being called immediately after
extern void ResumeNavigation(void);//clears buffers
extern char NavigationPaused(void);//lets you know if navigation is paused
extern void DelayWithNavigation(int ms);//like delay(ms) but keeps track of how position and orientation changes

extern int GetDegrees(void);
#define GetDegreesPerSecondZ GetDegreesPerSecond
extern int GetDegreesPerSecond(void);
extern int GetDegreesPerSecondX(void);
extern int GetDegreesPerSecondY(void);
extern int GetDegreesToStop(void);

extern int GetAccelerationX(void);// mm/sec^2
extern int GetAccelerationY(void);// mm/sec^2
extern int GetAccelerationZ(void);// mm/sec^2
extern int GetVelocityX(void);// mm/sec
extern int GetVelocityY(void);// mm/sec
extern int GetPositionX(void);// mm
extern int GetPositionY(void);// mm

// ***************************************************
// end Navigation
// ***************************************************


// ***************************************************
// AutoNavigation Plus IR
// ***************************************************
extern void AutoNavigationBegin(int Ms);
extern void ChangeAutoNavigationInterval(int Ms);
extern void AutoNavigationStop(void);
// ***************************************************
// end AutoNavigation Plus IR
// ***************************************************



// ***************************************************
// Accel
// ***************************************************
extern int AccelZeroes[3];
extern int32_t AccelPosition[3];//running total
extern int32_t AccelVelocity[3];//running total
extern int AccelAcceleration[3];
extern int32_t AccelDistance;

extern uint8_t AccelReadRegisters(uint8_t Reg, uint8_t *RxBuffer, uint8_t Length);
extern uint8_t AccelReadRegister(uint8_t Reg);
extern void AccelWriteRegisters(uint8_t Reg, uint8_t *TxBuffer, uint8_t Length);
extern void AccelWriteRegister(uint8_t Reg, uint8_t TxData);
//Put in standby to change register settings
extern void AccelStandby(void);
//Needs to be in this mode to output data
extern void AccelActive(void);

extern uint8_t AccelBufferSize(void);
extern int AccelGetAxis(char Axis);//Axis=0,1,2 
extern void AccelGetAxes(int *Axes);//Axis=0,1,2  [int is 16 bit in adruino]

// ***************************************************
// end Accel
// ***************************************************







// ***************************************************
// Gyro
// ***************************************************

extern int GyroZeroes[3];
extern int32_t GyroPosition[3];//running total
extern int GyroVelocity[3];//raw values go here
extern int GyroAccelerationZ;//derivative of GyroVelocity[2] (z-axis)

extern int GyroRange;//default value for chip
extern int GyroFrequency;

extern uint8_t GyroBufferSize(void);
extern int16_t GyroGetAxis(char Axis);//Axis=0,1,2 (p.36)
extern void GyroGetAxes(int *Axes);//Axis=0,1,2
//
extern void GyroSetRange(int Range);
#define GyroGetRange() GyroRange
extern int GyroGetRangeFromChip(void);
extern void GyroSetFrequency(int Frequency);
#define GyroGetFrequency() GyroFrequency
extern int GyroGetFrequencyFromChip(void);
extern int32_t GyroDegreesToRaw(int Degrees);
extern int GyroDegreesPerSecToRaw(int Degrees);
extern int GyroRawToDegrees(int32_t Raw);
extern int GyroRawToDegreesPerSec(int Raw);
extern int GyroDegreesToStopFromRaw(int DegreesPerSecondRaw);
extern int GyroDegreesToStop(int DegreesPerSecond);
//
extern uint8_t GyroReadRegisters(uint8_t Reg, uint8_t *RxBuffer, uint8_t Length);
extern uint8_t GyroReadRegister(uint8_t Reg);
extern void GyroWriteRegisters(uint8_t Reg, uint8_t *TxBuffer, uint8_t Length);
extern void GyroWriteRegister(uint8_t Reg, uint8_t TxData);



// ***************************************************
// emd Gyro
// ***************************************************


#endif



/*
  nexttime=millis();
  NavigationBegin();
  while(1){
    Serial.print(GyroFifoOverflow,10);
    Serial.print(AccelFifoOverflow,10);
    Serial.print("  ");
    Serial.print(GetDegrees(),10);
    Serial.print("  ");   
    Serial.print((millis()-nexttime)/1000);
    Serial.print("  "); 
    Serial.println(GetPositionY(),10);
    SimpleNavigation();delay(20);SimpleNavigation();delay(20);SimpleNavigation();delay(20);SimpleNavigation();delay(20);SimpleNavigation(); 
    if(ButtonPressed()){ 
      while(ButtonPressed());     
      delay(500);           
      ZeroNavigation();
      AccelFifoOverflow=0;
      GyroFifoOverflow=0;
      SimpleNavigation();
    }
  }
*/
/*  
  nexttime=millis();
  AutoNavigationBegin(3);
  while(1){
    Serial.print(GyroFifoOverflow,10);
    Serial.print(AccelFifoOverflow,10);
    Serial.print("  ");
    Serial.print(GetDegrees(),10);
    Serial.print("  ");   
    Serial.print((millis()-nexttime)/1000);
    Serial.print("  "); 
    Serial.println(GetPositionY(),10);    
    delay(100);    
    //Remove following section if using button pin for looking at timing
    if(ButtonPressed()){
      while(ButtonPressed());     
      delay(500);
      ZeroNavigation();
      ResumeNavigation(); 
    }    
  }
*/


